﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Newsletter
{
    public partial class EditNewsletters : System.Web.UI.Page
    {
        private NewsLetters currNewsLetters;

        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdNewsLettersID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowNewsLettersDetails();
                }
            }
        }

        private void ShowNewsLettersDetails()
        {
            currNewsLetters = NewsLettersBL.GetItem(Guid.Parse(hdNewsLettersID.Value.Trim()), string.Empty);
            if (currNewsLetters != null)
            {
                hdNewsLettersID.Value = currNewsLetters.UniqueID.ToString();
                txtEmailSubject.Text = currNewsLetters.EmailSubject;
                txtEmailMessage.Text = currNewsLetters.EmailMessage;
                chkIsActive.Checked = currNewsLetters.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                currNewsLetters = new NewsLetters();
                if (hdNewsLettersID.Value.Trim().Length == 0)
                    currNewsLetters.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    currNewsLetters.Mode = GlobalConfigurations.Mode.Update;
                    currNewsLetters.UniqueID = Guid.Parse(hdNewsLettersID.Value.Trim());
                }

                currNewsLetters.EmailSubject = txtEmailSubject.Text.Trim();
                currNewsLetters.EmailMessage = txtEmailMessage.Text.Trim();
                currNewsLetters.IsActive = chkIsActive.Checked;
                currNewsLetters.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (NewsLettersBL.Save(currNewsLetters))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "News Letter details has been saved successfully.<br>Do you want to add another News Lettes?", this.ResolveClientUrl("~/Admin/NewsLetter/EditNewsletters.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Newsletter/NewsLetters.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtEmailSubject.Text.Trim()))
            {
                WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtEmailSubject.ClientID + "', 'Please enter valid Email Subject.');");
                return false;
            }

            if (!ValidationUtility.ValidateString(txtEmailMessage.Text.Trim()))
            {
                WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtEmailMessage.ClientID + "', 'Please enter valid Email Message.');");
                return false;
            }

            return true;
        }
    }
}